﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;

using HIPS.Web.ModelInterface.Common;
using HIPS.Web.ModelInterface.PcehrView;

namespace HIPS.Web.UI.Helpers
{

    /// <summary>
    /// Extension methods for working with repositories.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="10 January 2014">Initial version.</change>
    /// </history>
    public static class RepositoryExtensions
    {

        #region Methods

        /// <summary>
        /// Gets a specified patient in hospital.
        /// </summary>
        /// <param name="r">IPatientRepository.</param>
        /// <param name="patientIdentifier">Identifier of the patient (MRN).</param>
        /// <param name="operatingUser">User requesting the operation.</param>
        /// <returns>PatientInHospital</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="10 January 2014">Initial version.</change>
        /// </history>
        internal static PatientSchemas.PatientInHospital GetPatientInHospital(this IPatientRepository r, Mrn patientIdentifier, UserDetails operatingUser)
        {
            //Load patients for specified hospital.
            var patients = r.ListPatientsCurrentlyInHospital(patientIdentifier.HospitalCodeSystem, patientIdentifier.HospitalCode, true, operatingUser);

            // Ensure loading was successful.
            if (patients.IsSuccessful)
            {
                if (patients.Data.PatientInHospitalList.Count > 0)
                {
                    return patients.Data.PatientInHospitalList.Single(p => p.Mrn == patientIdentifier.Value);
                }
            }

            throw new System.Exception("Could not retrieve specified patient.");
        }

        /// <summary>
        /// Gets metadata for a specified document.
        /// </summary>
        /// <param name="r">IPcehrViewRepository.</param>
        /// <param name="patientIdentifier">Identifier of the patient (MRN).</param>
        /// <param name="repositoryId">Identifier of the repository.</param>
        /// <param name="documentId">Identifier of the document.</param>
        /// <param name="operatingUser">User requesting the operation.</param>
        /// <returns>DocumentMetaDataItem</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="10 January 2014">Initial version.</change>
        /// </history>
        internal static DocumentMetaDataItem GetDocumentMetaData(this IPcehrViewRepository r, Mrn patientIdentifier, string repositoryId, string documentId, UserDetails operatingUser)
        {
            //Load documents for specified patient.
            var docs = r.ListActiveDocuments(patientIdentifier, operatingUser);

            //Ensure loading was successful.
            if (docs.IsSuccessful)
            {
                if (docs.Data.DocumentList.Count > 0)
                {
                    return docs.Data.DocumentList.Single(d => (d.RepositoryUniqueId == repositoryId) && (d.DocumentUniqueId == documentId));
                }
            }

            throw new System.Exception("Could not retrieve specified document.");
        }

        #endregion

    }
}